DROP PROCEDURE [hips].[PatientMasterNameGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 18 October 2012
-- Description:   Gets a specified record from the Patient Master Name Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterNameGet] 
(
	@PatientMasterNameId INT = NULL,
	@PatientMasterId INT = NULL
)
AS
BEGIN
SELECT  pmn.PatientMasterNameId,
		pmn.PatientMasterId,
		pmn.TitleId,
		t.Description AS Title,
		pmn.GivenNames,
		pmn.FamilyName,
		pmn.SuffixId,
		s.Description AS Suffix,
		pmn.NameTypeId,
		nt.Description AS NameType,
		pmn.DateCreated,
		pmn.UserCreated,
		pmn.DateModified,
		pmn.UserModified
		
FROM  hips.PatientMasterName pmn
LEFT OUTER JOIN hips.Title AS t ON t.TitleId = pmn.TitleId
LEFT OUTER JOIN hips.Suffix AS s ON s.SuffixId = pmn.SuffixId
LEFT OUTER JOIN hips.NameType AS nt ON nt.NameTypeId = pmn.NameTypeId
WHERE (pmn.PatientMasterNameId = @PatientMasterNameId OR @PatientMasterNameId IS NULL)
AND   (pmn.PatientMasterId = @PatientMasterId OR @PatientMasterId IS NULL)
END
GO

